package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{
  MultiRegionAccessPointClientToken,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class CreateMultiRegionAccessPointRequest(
    accountId: AccountId,
    clientToken: MultiRegionAccessPointClientToken,
    details: zio.aws.s3control.model.CreateMultiRegionAccessPointInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointRequest = {
    import CreateMultiRegionAccessPointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .clientToken(
        MultiRegionAccessPointClientToken.unwrap(clientToken): java.lang.String
      )
      .details(details.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.CreateMultiRegionAccessPointRequest.ReadOnly =
    zio.aws.s3control.model.CreateMultiRegionAccessPointRequest
      .wrap(buildAwsValue())
}
object CreateMultiRegionAccessPointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.CreateMultiRegionAccessPointRequest =
      zio.aws.s3control.model.CreateMultiRegionAccessPointRequest(
        accountId,
        clientToken,
        details.asEditable
      )
    def accountId: AccountId
    def clientToken: MultiRegionAccessPointClientToken
    def details
        : zio.aws.s3control.model.CreateMultiRegionAccessPointInput.ReadOnly
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getClientToken: ZIO[Any, Nothing, MultiRegionAccessPointClientToken] =
      ZIO.succeed(clientToken)
    def getDetails: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.CreateMultiRegionAccessPointInput.ReadOnly
    ] = ZIO.succeed(details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointRequest
  ) extends zio.aws.s3control.model.CreateMultiRegionAccessPointRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val clientToken: MultiRegionAccessPointClientToken =
      zio.aws.s3control.model.primitives
        .MultiRegionAccessPointClientToken(impl.clientToken())
    override val details
        : zio.aws.s3control.model.CreateMultiRegionAccessPointInput.ReadOnly =
      zio.aws.s3control.model.CreateMultiRegionAccessPointInput
        .wrap(impl.details())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointRequest
  ): zio.aws.s3control.model.CreateMultiRegionAccessPointRequest.ReadOnly =
    new Wrapper(impl)
}
