package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{
  ObjectLambdaAccessPointName,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class DeleteAccessPointForObjectLambdaRequest(
    accountId: AccountId,
    name: ObjectLambdaAccessPointName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaRequest = {
    import DeleteAccessPointForObjectLambdaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .name(ObjectLambdaAccessPointName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.DeleteAccessPointForObjectLambdaRequest.ReadOnly =
    zio.aws.s3control.model.DeleteAccessPointForObjectLambdaRequest
      .wrap(buildAwsValue())
}
object DeleteAccessPointForObjectLambdaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.DeleteAccessPointForObjectLambdaRequest =
      zio.aws.s3control.model
        .DeleteAccessPointForObjectLambdaRequest(accountId, name)
    def accountId: AccountId
    def name: ObjectLambdaAccessPointName
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getName: ZIO[Any, Nothing, ObjectLambdaAccessPointName] =
      ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaRequest
  ) extends zio.aws.s3control.model.DeleteAccessPointForObjectLambdaRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val name: ObjectLambdaAccessPointName =
      zio.aws.s3control.model.primitives
        .ObjectLambdaAccessPointName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaRequest
  ): zio.aws.s3control.model.DeleteAccessPointForObjectLambdaRequest.ReadOnly =
    new Wrapper(impl)
}
