package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.MultiRegionAccessPointName
import scala.jdk.CollectionConverters.*
final case class DeleteMultiRegionAccessPointInput(
    name: MultiRegionAccessPointName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointInput = {
    import DeleteMultiRegionAccessPointInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointInput
      .builder()
      .name(MultiRegionAccessPointName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.ReadOnly =
    zio.aws.s3control.model.DeleteMultiRegionAccessPointInput
      .wrap(buildAwsValue())
}
object DeleteMultiRegionAccessPointInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.DeleteMultiRegionAccessPointInput =
      zio.aws.s3control.model.DeleteMultiRegionAccessPointInput(name)
    def name: MultiRegionAccessPointName
    def getName: ZIO[Any, Nothing, MultiRegionAccessPointName] =
      ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointInput
  ) extends zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.ReadOnly {
    override val name: MultiRegionAccessPointName =
      zio.aws.s3control.model.primitives.MultiRegionAccessPointName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointInput
  ): zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.ReadOnly =
    new Wrapper(impl)
}
