package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeMultiRegionAccessPointOperationResponse(
    asyncOperation: Optional[zio.aws.s3control.model.AsyncOperation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationResponse = {
    import DescribeMultiRegionAccessPointOperationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationResponse
      .builder()
      .optionallyWith(asyncOperation.map(value => value.buildAwsValue()))(
        _.asyncOperation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationResponse.ReadOnly =
    zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationResponse
      .wrap(buildAwsValue())
}
object DescribeMultiRegionAccessPointOperationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationResponse =
      zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationResponse(
        asyncOperation.map(value => value.asEditable)
      )
    def asyncOperation
        : Optional[zio.aws.s3control.model.AsyncOperation.ReadOnly]
    def getAsyncOperation
        : ZIO[Any, AwsError, zio.aws.s3control.model.AsyncOperation.ReadOnly] =
      AwsError.unwrapOptionField("asyncOperation", asyncOperation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationResponse
  ) extends zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationResponse.ReadOnly {
    override val asyncOperation
        : Optional[zio.aws.s3control.model.AsyncOperation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.asyncOperation())
        .map(value => zio.aws.s3control.model.AsyncOperation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationResponse
  ): zio.aws.s3control.model.DescribeMultiRegionAccessPointOperationResponse.ReadOnly =
    new Wrapper(impl)
}
