package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.Policy
import scala.jdk.CollectionConverters.*
final case class EstablishedMultiRegionAccessPointPolicy(
    policy: Optional[Policy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.EstablishedMultiRegionAccessPointPolicy = {
    import EstablishedMultiRegionAccessPointPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.EstablishedMultiRegionAccessPointPolicy
      .builder()
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy.ReadOnly =
    zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy
      .wrap(buildAwsValue())
}
object EstablishedMultiRegionAccessPointPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.EstablishedMultiRegionAccessPointPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy =
      zio.aws.s3control.model
        .EstablishedMultiRegionAccessPointPolicy(policy.map(value => value))
    def policy: Optional[Policy]
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.EstablishedMultiRegionAccessPointPolicy
  ) extends zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy.ReadOnly {
    override val policy: Optional[Policy] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.s3control.model.primitives.Policy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.EstablishedMultiRegionAccessPointPolicy
  ): zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy.ReadOnly =
    new Wrapper(impl)
}
