package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAccessPointPolicyStatusResponse(
    policyStatus: Optional[zio.aws.s3control.model.PolicyStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusResponse = {
    import GetAccessPointPolicyStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusResponse
      .builder()
      .optionallyWith(policyStatus.map(value => value.buildAwsValue()))(
        _.policyStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetAccessPointPolicyStatusResponse.ReadOnly =
    zio.aws.s3control.model.GetAccessPointPolicyStatusResponse
      .wrap(buildAwsValue())
}
object GetAccessPointPolicyStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetAccessPointPolicyStatusResponse =
      zio.aws.s3control.model.GetAccessPointPolicyStatusResponse(
        policyStatus.map(value => value.asEditable)
      )
    def policyStatus: Optional[zio.aws.s3control.model.PolicyStatus.ReadOnly]
    def getPolicyStatus
        : ZIO[Any, AwsError, zio.aws.s3control.model.PolicyStatus.ReadOnly] =
      AwsError.unwrapOptionField("policyStatus", policyStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusResponse
  ) extends zio.aws.s3control.model.GetAccessPointPolicyStatusResponse.ReadOnly {
    override val policyStatus
        : Optional[zio.aws.s3control.model.PolicyStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyStatus())
        .map(value => zio.aws.s3control.model.PolicyStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusResponse
  ): zio.aws.s3control.model.GetAccessPointPolicyStatusResponse.ReadOnly =
    new Wrapper(impl)
}
