package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.Policy
import scala.jdk.CollectionConverters.*
final case class GetBucketPolicyResponse(
    policy: Optional[Policy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetBucketPolicyResponse = {
    import GetBucketPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetBucketPolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.GetBucketPolicyResponse.ReadOnly =
    zio.aws.s3control.model.GetBucketPolicyResponse.wrap(buildAwsValue())
}
object GetBucketPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetBucketPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetBucketPolicyResponse =
      zio.aws.s3control.model
        .GetBucketPolicyResponse(policy.map(value => value))
    def policy: Optional[Policy]
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketPolicyResponse
  ) extends zio.aws.s3control.model.GetBucketPolicyResponse.ReadOnly {
    override val policy: Optional[Policy] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.s3control.model.primitives.Policy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketPolicyResponse
  ): zio.aws.s3control.model.GetBucketPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
