package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  CreationDate,
  PublicAccessBlockEnabled,
  BucketName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetBucketResponse(
    bucket: Optional[BucketName] = Optional.Absent,
    publicAccessBlockEnabled: Optional[PublicAccessBlockEnabled] =
      Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetBucketResponse = {
    import GetBucketResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetBucketResponse
      .builder()
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        publicAccessBlockEnabled.map(value =>
          PublicAccessBlockEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.publicAccessBlockEnabled)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.GetBucketResponse.ReadOnly =
    zio.aws.s3control.model.GetBucketResponse.wrap(buildAwsValue())
}
object GetBucketResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetBucketResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetBucketResponse =
      zio.aws.s3control.model.GetBucketResponse(
        bucket.map(value => value),
        publicAccessBlockEnabled.map(value => value),
        creationDate.map(value => value)
      )
    def bucket: Optional[BucketName]
    def publicAccessBlockEnabled: Optional[PublicAccessBlockEnabled]
    def creationDate: Optional[CreationDate]
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getPublicAccessBlockEnabled
        : ZIO[Any, AwsError, PublicAccessBlockEnabled] = AwsError
      .unwrapOptionField("publicAccessBlockEnabled", publicAccessBlockEnabled)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketResponse
  ) extends zio.aws.s3control.model.GetBucketResponse.ReadOnly {
    override val bucket: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.s3control.model.primitives.BucketName(value))
    override val publicAccessBlockEnabled: Optional[PublicAccessBlockEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicAccessBlockEnabled())
        .map(value =>
          zio.aws.s3control.model.primitives.PublicAccessBlockEnabled(value)
        )
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.s3control.model.primitives.CreationDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketResponse
  ): zio.aws.s3control.model.GetBucketResponse.ReadOnly = new Wrapper(impl)
}
