package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class GetPublicAccessBlockRequest(accountId: AccountId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest = {
    import GetPublicAccessBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.GetPublicAccessBlockRequest.ReadOnly =
    zio.aws.s3control.model.GetPublicAccessBlockRequest.wrap(buildAwsValue())
}
object GetPublicAccessBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetPublicAccessBlockRequest =
      zio.aws.s3control.model.GetPublicAccessBlockRequest(accountId)
    def accountId: AccountId
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest
  ) extends zio.aws.s3control.model.GetPublicAccessBlockRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest
  ): zio.aws.s3control.model.GetPublicAccessBlockRequest.ReadOnly = new Wrapper(
    impl
  )
}
