package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait JobReportScope {
  def unwrap: software.amazon.awssdk.services.s3control.model.JobReportScope
}
object JobReportScope {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.JobReportScope
  ): zio.aws.s3control.model.JobReportScope = value match {
    case software.amazon.awssdk.services.s3control.model.JobReportScope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.JobReportScope.ALL_TASKS =>
      val r = AllTasks
      r
    case software.amazon.awssdk.services.s3control.model.JobReportScope.FAILED_TASKS_ONLY =>
      val r = FailedTasksOnly
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.JobReportScope {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobReportScope =
      software.amazon.awssdk.services.s3control.model.JobReportScope.UNKNOWN_TO_SDK_VERSION
  }
  case object AllTasks extends zio.aws.s3control.model.JobReportScope {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobReportScope =
      software.amazon.awssdk.services.s3control.model.JobReportScope.ALL_TASKS
  }
  case object FailedTasksOnly extends zio.aws.s3control.model.JobReportScope {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobReportScope =
      software.amazon.awssdk.services.s3control.model.JobReportScope.FAILED_TASKS_ONLY
  }
}
