package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  ExpiredObjectDeleteMarker,
  Days,
  Date
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class LifecycleExpiration(
    date: Optional[Date] = Optional.Absent,
    days: Optional[Days] = Optional.Absent,
    expiredObjectDeleteMarker: Optional[ExpiredObjectDeleteMarker] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.LifecycleExpiration = {
    import LifecycleExpiration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.LifecycleExpiration
      .builder()
      .optionallyWith(date.map(value => Date.unwrap(value): Instant))(_.date)
      .optionallyWith(days.map(value => Days.unwrap(value): Integer))(_.days)
      .optionallyWith(
        expiredObjectDeleteMarker.map(value =>
          ExpiredObjectDeleteMarker.unwrap(value): java.lang.Boolean
        )
      )(_.expiredObjectDeleteMarker)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.LifecycleExpiration.ReadOnly =
    zio.aws.s3control.model.LifecycleExpiration.wrap(buildAwsValue())
}
object LifecycleExpiration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.LifecycleExpiration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.LifecycleExpiration =
      zio.aws.s3control.model.LifecycleExpiration(
        date.map(value => value),
        days.map(value => value),
        expiredObjectDeleteMarker.map(value => value)
      )
    def date: Optional[Date]
    def days: Optional[Days]
    def expiredObjectDeleteMarker: Optional[ExpiredObjectDeleteMarker]
    def getDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("date", date)
    def getDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("days", days)
    def getExpiredObjectDeleteMarker
        : ZIO[Any, AwsError, ExpiredObjectDeleteMarker] = AwsError
      .unwrapOptionField("expiredObjectDeleteMarker", expiredObjectDeleteMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.LifecycleExpiration
  ) extends zio.aws.s3control.model.LifecycleExpiration.ReadOnly {
    override val date: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.s3control.model.primitives.Date(value))
    override val days: Optional[Days] = zio.aws.core.internal
      .optionalFromNullable(impl.days())
      .map(value => zio.aws.s3control.model.primitives.Days(value))
    override val expiredObjectDeleteMarker
        : Optional[ExpiredObjectDeleteMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.expiredObjectDeleteMarker())
      .map(value =>
        zio.aws.s3control.model.primitives.ExpiredObjectDeleteMarker(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.LifecycleExpiration
  ): zio.aws.s3control.model.LifecycleExpiration.ReadOnly = new Wrapper(impl)
}
