package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  MaxResults,
  NonEmptyMaxLength1024String,
  AccountId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMultiRegionAccessPointsRequest(
    accountId: AccountId,
    nextToken: Optional[NonEmptyMaxLength1024String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsRequest = {
    import ListMultiRegionAccessPointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(
        nextToken.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.ListMultiRegionAccessPointsRequest.ReadOnly =
    zio.aws.s3control.model.ListMultiRegionAccessPointsRequest
      .wrap(buildAwsValue())
}
object ListMultiRegionAccessPointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ListMultiRegionAccessPointsRequest =
      zio.aws.s3control.model.ListMultiRegionAccessPointsRequest(
        accountId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def accountId: AccountId
    def nextToken: Optional[NonEmptyMaxLength1024String]
    def maxResults: Optional[MaxResults]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getNextToken: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsRequest
  ) extends zio.aws.s3control.model.ListMultiRegionAccessPointsRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val nextToken: Optional[NonEmptyMaxLength1024String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.s3control.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsRequest
  ): zio.aws.s3control.model.ListMultiRegionAccessPointsRequest.ReadOnly =
    new Wrapper(impl)
}
