package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.ContinuationToken
import scala.jdk.CollectionConverters.*
final case class ListStorageLensConfigurationsResponse(
    nextToken: Optional[ContinuationToken] = Optional.Absent,
    storageLensConfigurationList: Optional[
      Iterable[zio.aws.s3control.model.ListStorageLensConfigurationEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse = {
    import ListStorageLensConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value =>
          ContinuationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        storageLensConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageLensConfigurationList)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.ListStorageLensConfigurationsResponse.ReadOnly =
    zio.aws.s3control.model.ListStorageLensConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListStorageLensConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.ListStorageLensConfigurationsResponse =
      zio.aws.s3control.model.ListStorageLensConfigurationsResponse(
        nextToken.map(value => value),
        storageLensConfigurationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[ContinuationToken]
    def storageLensConfigurationList: Optional[
      List[zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, ContinuationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStorageLensConfigurationList: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "storageLensConfigurationList",
      storageLensConfigurationList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse
  ) extends zio.aws.s3control.model.ListStorageLensConfigurationsResponse.ReadOnly {
    override val nextToken: Optional[ContinuationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.s3control.model.primitives.ContinuationToken(value))
    override val storageLensConfigurationList: Optional[
      List[zio.aws.s3control.model.ListStorageLensConfigurationEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.storageLensConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3control.model.ListStorageLensConfigurationEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse
  ): zio.aws.s3control.model.ListStorageLensConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
