package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait MultiRegionAccessPointStatus {
  def unwrap: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus
}
object MultiRegionAccessPointStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus
  ): zio.aws.s3control.model.MultiRegionAccessPointStatus = value match {
    case software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.INCONSISTENT_ACROSS_REGIONS =>
      val r = INCONSISTENT_ACROSS_REGIONS
      r
    case software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.PARTIALLY_CREATED =>
      val r = PARTIALLY_CREATED
      r
    case software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.PARTIALLY_DELETED =>
      val r = PARTIALLY_DELETED
      r
    case software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.MultiRegionAccessPointStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus =
      software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object READY
      extends zio.aws.s3control.model.MultiRegionAccessPointStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus =
      software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.READY
  }
  case object INCONSISTENT_ACROSS_REGIONS
      extends zio.aws.s3control.model.MultiRegionAccessPointStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus =
      software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.INCONSISTENT_ACROSS_REGIONS
  }
  case object CREATING
      extends zio.aws.s3control.model.MultiRegionAccessPointStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus =
      software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.CREATING
  }
  case object PARTIALLY_CREATED
      extends zio.aws.s3control.model.MultiRegionAccessPointStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus =
      software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.PARTIALLY_CREATED
  }
  case object PARTIALLY_DELETED
      extends zio.aws.s3control.model.MultiRegionAccessPointStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus =
      software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.PARTIALLY_DELETED
  }
  case object DELETING
      extends zio.aws.s3control.model.MultiRegionAccessPointStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus =
      software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointStatus.DELETING
  }
}
