package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ObjectLambdaContentTransformation(
    awsLambda: Optional[zio.aws.s3control.model.AwsLambdaTransformation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ObjectLambdaContentTransformation = {
    import ObjectLambdaContentTransformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ObjectLambdaContentTransformation
      .builder()
      .optionallyWith(awsLambda.map(value => value.buildAwsValue()))(
        _.awsLambda
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.ObjectLambdaContentTransformation.ReadOnly =
    zio.aws.s3control.model.ObjectLambdaContentTransformation
      .wrap(buildAwsValue())
}
object ObjectLambdaContentTransformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ObjectLambdaContentTransformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ObjectLambdaContentTransformation =
      zio.aws.s3control.model.ObjectLambdaContentTransformation(
        awsLambda.map(value => value.asEditable)
      )
    def awsLambda
        : Optional[zio.aws.s3control.model.AwsLambdaTransformation.ReadOnly]
    def getAwsLambda: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.AwsLambdaTransformation.ReadOnly
    ] = AwsError.unwrapOptionField("awsLambda", awsLambda)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ObjectLambdaContentTransformation
  ) extends zio.aws.s3control.model.ObjectLambdaContentTransformation.ReadOnly {
    override val awsLambda
        : Optional[zio.aws.s3control.model.AwsLambdaTransformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsLambda())
        .map(value =>
          zio.aws.s3control.model.AwsLambdaTransformation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ObjectLambdaContentTransformation
  ): zio.aws.s3control.model.ObjectLambdaContentTransformation.ReadOnly =
    new Wrapper(impl)
}
