package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.Setting
import scala.jdk.CollectionConverters.*
final case class PublicAccessBlockConfiguration(
    blockPublicAcls: Optional[Setting] = Optional.Absent,
    ignorePublicAcls: Optional[Setting] = Optional.Absent,
    blockPublicPolicy: Optional[Setting] = Optional.Absent,
    restrictPublicBuckets: Optional[Setting] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PublicAccessBlockConfiguration = {
    import PublicAccessBlockConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PublicAccessBlockConfiguration
      .builder()
      .optionallyWith(
        blockPublicAcls.map(value => Setting.unwrap(value): java.lang.Boolean)
      )(_.blockPublicAcls)
      .optionallyWith(
        ignorePublicAcls.map(value => Setting.unwrap(value): java.lang.Boolean)
      )(_.ignorePublicAcls)
      .optionallyWith(
        blockPublicPolicy.map(value => Setting.unwrap(value): java.lang.Boolean)
      )(_.blockPublicPolicy)
      .optionallyWith(
        restrictPublicBuckets.map(value =>
          Setting.unwrap(value): java.lang.Boolean
        )
      )(_.restrictPublicBuckets)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly =
    zio.aws.s3control.model.PublicAccessBlockConfiguration.wrap(buildAwsValue())
}
object PublicAccessBlockConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PublicAccessBlockConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.PublicAccessBlockConfiguration =
      zio.aws.s3control.model.PublicAccessBlockConfiguration(
        blockPublicAcls.map(value => value),
        ignorePublicAcls.map(value => value),
        blockPublicPolicy.map(value => value),
        restrictPublicBuckets.map(value => value)
      )
    def blockPublicAcls: Optional[Setting]
    def ignorePublicAcls: Optional[Setting]
    def blockPublicPolicy: Optional[Setting]
    def restrictPublicBuckets: Optional[Setting]
    def getBlockPublicAcls: ZIO[Any, AwsError, Setting] =
      AwsError.unwrapOptionField("blockPublicAcls", blockPublicAcls)
    def getIgnorePublicAcls: ZIO[Any, AwsError, Setting] =
      AwsError.unwrapOptionField("ignorePublicAcls", ignorePublicAcls)
    def getBlockPublicPolicy: ZIO[Any, AwsError, Setting] =
      AwsError.unwrapOptionField("blockPublicPolicy", blockPublicPolicy)
    def getRestrictPublicBuckets: ZIO[Any, AwsError, Setting] =
      AwsError.unwrapOptionField("restrictPublicBuckets", restrictPublicBuckets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PublicAccessBlockConfiguration
  ) extends zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly {
    override val blockPublicAcls: Optional[Setting] = zio.aws.core.internal
      .optionalFromNullable(impl.blockPublicAcls())
      .map(value => zio.aws.s3control.model.primitives.Setting(value))
    override val ignorePublicAcls: Optional[Setting] = zio.aws.core.internal
      .optionalFromNullable(impl.ignorePublicAcls())
      .map(value => zio.aws.s3control.model.primitives.Setting(value))
    override val blockPublicPolicy: Optional[Setting] = zio.aws.core.internal
      .optionalFromNullable(impl.blockPublicPolicy())
      .map(value => zio.aws.s3control.model.primitives.Setting(value))
    override val restrictPublicBuckets: Optional[Setting] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restrictPublicBuckets())
        .map(value => zio.aws.s3control.model.primitives.Setting(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PublicAccessBlockConfiguration
  ): zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly =
    new Wrapper(impl)
}
