package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{JobId, AccountId}
import scala.jdk.CollectionConverters.*
final case class PutJobTaggingRequest(
    accountId: AccountId,
    jobId: JobId,
    tags: Iterable[zio.aws.s3control.model.S3Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutJobTaggingRequest = {
    import PutJobTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutJobTaggingRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.PutJobTaggingRequest.ReadOnly =
    zio.aws.s3control.model.PutJobTaggingRequest.wrap(buildAwsValue())
}
object PutJobTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutJobTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.PutJobTaggingRequest =
      zio.aws.s3control.model.PutJobTaggingRequest(
        accountId,
        jobId,
        tags.map { item =>
          item.asEditable
        }
      )
    def accountId: AccountId
    def jobId: JobId
    def tags: List[zio.aws.s3control.model.S3Tag.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutJobTaggingRequest
  ) extends zio.aws.s3control.model.PutJobTaggingRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val jobId: JobId =
      zio.aws.s3control.model.primitives.JobId(impl.jobId())
    override val tags: List[zio.aws.s3control.model.S3Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.s3control.model.S3Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutJobTaggingRequest
  ): zio.aws.s3control.model.PutJobTaggingRequest.ReadOnly = new Wrapper(impl)
}
