package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait ReplicationStatus {
  def unwrap: software.amazon.awssdk.services.s3control.model.ReplicationStatus
}
object ReplicationStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.ReplicationStatus
  ): zio.aws.s3control.model.ReplicationStatus = value match {
    case software.amazon.awssdk.services.s3control.model.ReplicationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStatus.REPLICA =>
      val r = REPLICA
      r
    case software.amazon.awssdk.services.s3control.model.ReplicationStatus.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStatus =
      software.amazon.awssdk.services.s3control.model.ReplicationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETED extends zio.aws.s3control.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStatus =
      software.amazon.awssdk.services.s3control.model.ReplicationStatus.COMPLETED
  }
  case object FAILED extends zio.aws.s3control.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStatus =
      software.amazon.awssdk.services.s3control.model.ReplicationStatus.FAILED
  }
  case object REPLICA extends zio.aws.s3control.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStatus =
      software.amazon.awssdk.services.s3control.model.ReplicationStatus.REPLICA
  }
  case object NONE extends zio.aws.s3control.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ReplicationStatus =
      software.amazon.awssdk.services.s3control.model.ReplicationStatus.NONE
  }
}
