package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait RequestedJobStatus {
  def unwrap: software.amazon.awssdk.services.s3control.model.RequestedJobStatus
}
object RequestedJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.RequestedJobStatus
  ): zio.aws.s3control.model.RequestedJobStatus = value match {
    case software.amazon.awssdk.services.s3control.model.RequestedJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.RequestedJobStatus.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.s3control.model.RequestedJobStatus.READY =>
      val r = Ready
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.RequestedJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.RequestedJobStatus =
      software.amazon.awssdk.services.s3control.model.RequestedJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Cancelled extends zio.aws.s3control.model.RequestedJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.RequestedJobStatus =
      software.amazon.awssdk.services.s3control.model.RequestedJobStatus.CANCELLED
  }
  case object Ready extends zio.aws.s3control.model.RequestedJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.RequestedJobStatus =
      software.amazon.awssdk.services.s3control.model.RequestedJobStatus.READY
  }
}
