package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait S3CannedAccessControlList {
  def unwrap: software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList
}
object S3CannedAccessControlList {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList
  ): zio.aws.s3control.model.S3CannedAccessControlList = value match {
    case software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.PRIVATE =>
      val r = `private`
      r
    case software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.PUBLIC_READ =>
      val r = `public-read`
      r
    case software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.PUBLIC_READ_WRITE =>
      val r = `public-read-write`
      r
    case software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.AWS_EXEC_READ =>
      val r = `aws-exec-read`
      r
    case software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.AUTHENTICATED_READ =>
      val r = `authenticated-read`
      r
    case software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.BUCKET_OWNER_READ =>
      val r = `bucket-owner-read`
      r
    case software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.BUCKET_OWNER_FULL_CONTROL =>
      val r = `bucket-owner-full-control`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.S3CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList =
      software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.UNKNOWN_TO_SDK_VERSION
  }
  case object `private`
      extends zio.aws.s3control.model.S3CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList =
      software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.PRIVATE
  }
  case object `public-read`
      extends zio.aws.s3control.model.S3CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList =
      software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.PUBLIC_READ
  }
  case object `public-read-write`
      extends zio.aws.s3control.model.S3CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList =
      software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.PUBLIC_READ_WRITE
  }
  case object `aws-exec-read`
      extends zio.aws.s3control.model.S3CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList =
      software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.AWS_EXEC_READ
  }
  case object `authenticated-read`
      extends zio.aws.s3control.model.S3CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList =
      software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.AUTHENTICATED_READ
  }
  case object `bucket-owner-read`
      extends zio.aws.s3control.model.S3CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList =
      software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.BUCKET_OWNER_READ
  }
  case object `bucket-owner-full-control`
      extends zio.aws.s3control.model.S3CannedAccessControlList {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList =
      software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList.BUCKET_OWNER_FULL_CONTROL
  }
}
