package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.TimeStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class S3Retention(
    retainUntilDate: Optional[TimeStamp] = Optional.Absent,
    mode: Optional[zio.aws.s3control.model.S3ObjectLockRetentionMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3Retention = {
    import S3Retention.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3Retention
      .builder()
      .optionallyWith(
        retainUntilDate.map(value => TimeStamp.unwrap(value): Instant)
      )(_.retainUntilDate)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3Retention.ReadOnly =
    zio.aws.s3control.model.S3Retention.wrap(buildAwsValue())
}
object S3Retention {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3Retention
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3Retention =
      zio.aws.s3control.model.S3Retention(
        retainUntilDate.map(value => value),
        mode.map(value => value)
      )
    def retainUntilDate: Optional[TimeStamp]
    def mode: Optional[zio.aws.s3control.model.S3ObjectLockRetentionMode]
    def getRetainUntilDate: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("retainUntilDate", retainUntilDate)
    def getMode: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3ObjectLockRetentionMode
    ] = AwsError.unwrapOptionField("mode", mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3Retention
  ) extends zio.aws.s3control.model.S3Retention.ReadOnly {
    override val retainUntilDate: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.retainUntilDate())
      .map(value => zio.aws.s3control.model.primitives.TimeStamp(value))
    override val mode
        : Optional[zio.aws.s3control.model.S3ObjectLockRetentionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value =>
          zio.aws.s3control.model.S3ObjectLockRetentionMode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3Retention
  ): zio.aws.s3control.model.S3Retention.ReadOnly = new Wrapper(impl)
}
