package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.AwsOrgArn
import scala.jdk.CollectionConverters.*
final case class StorageLensAwsOrg(arn: AwsOrgArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.StorageLensAwsOrg = {
    import StorageLensAwsOrg.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.StorageLensAwsOrg
      .builder()
      .arn(AwsOrgArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.StorageLensAwsOrg.ReadOnly =
    zio.aws.s3control.model.StorageLensAwsOrg.wrap(buildAwsValue())
}
object StorageLensAwsOrg {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.StorageLensAwsOrg
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.StorageLensAwsOrg =
      zio.aws.s3control.model.StorageLensAwsOrg(arn)
    def arn: AwsOrgArn
    def getArn: ZIO[Any, Nothing, AwsOrgArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.StorageLensAwsOrg
  ) extends zio.aws.s3control.model.StorageLensAwsOrg.ReadOnly {
    override val arn: AwsOrgArn =
      zio.aws.s3control.model.primitives.AwsOrgArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.StorageLensAwsOrg
  ): zio.aws.s3control.model.StorageLensAwsOrg.ReadOnly = new Wrapper(impl)
}
