package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Tagging(tagSet: Iterable[zio.aws.s3control.model.S3Tag]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.Tagging = {
    import Tagging.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.Tagging
      .builder()
      .tagSet(tagSet.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.Tagging.ReadOnly =
    zio.aws.s3control.model.Tagging.wrap(buildAwsValue())
}
object Tagging {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3control.model.Tagging] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.Tagging =
      zio.aws.s3control.model.Tagging(tagSet.map { item =>
        item.asEditable
      })
    def tagSet: List[zio.aws.s3control.model.S3Tag.ReadOnly]
    def getTagSet
        : ZIO[Any, Nothing, List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      ZIO.succeed(tagSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.Tagging
  ) extends zio.aws.s3control.model.Tagging.ReadOnly {
    override val tagSet: List[zio.aws.s3control.model.S3Tag.ReadOnly] = impl
      .tagSet()
      .asScala
      .map { item =>
        zio.aws.s3control.model.S3Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.Tagging
  ): zio.aws.s3control.model.Tagging.ReadOnly = new Wrapper(impl)
}
