package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait TransitionStorageClass {
  def unwrap
      : software.amazon.awssdk.services.s3control.model.TransitionStorageClass
}
object TransitionStorageClass {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.TransitionStorageClass
  ): zio.aws.s3control.model.TransitionStorageClass = value match {
    case software.amazon.awssdk.services.s3control.model.TransitionStorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.TransitionStorageClass.GLACIER =>
      val r = GLACIER
      r
    case software.amazon.awssdk.services.s3control.model.TransitionStorageClass.STANDARD_IA =>
      val r = STANDARD_IA
      r
    case software.amazon.awssdk.services.s3control.model.TransitionStorageClass.ONEZONE_IA =>
      val r = ONEZONE_IA
      r
    case software.amazon.awssdk.services.s3control.model.TransitionStorageClass.INTELLIGENT_TIERING =>
      val r = INTELLIGENT_TIERING
      r
    case software.amazon.awssdk.services.s3control.model.TransitionStorageClass.DEEP_ARCHIVE =>
      val r = DEEP_ARCHIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3control.model.TransitionStorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object GLACIER extends zio.aws.s3control.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3control.model.TransitionStorageClass.GLACIER
  }
  case object STANDARD_IA
      extends zio.aws.s3control.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3control.model.TransitionStorageClass.STANDARD_IA
  }
  case object ONEZONE_IA
      extends zio.aws.s3control.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3control.model.TransitionStorageClass.ONEZONE_IA
  }
  case object INTELLIGENT_TIERING
      extends zio.aws.s3control.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3control.model.TransitionStorageClass.INTELLIGENT_TIERING
  }
  case object DEEP_ARCHIVE
      extends zio.aws.s3control.model.TransitionStorageClass {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.TransitionStorageClass =
      software.amazon.awssdk.services.s3control.model.TransitionStorageClass.DEEP_ARCHIVE
  }
}
