package zio.aws.s3control.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{JobPriority, JobId, AccountId}
import scala.jdk.CollectionConverters.*
final case class UpdateJobPriorityRequest(
    accountId: AccountId,
    jobId: JobId,
    priority: JobPriority
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest = {
    import UpdateJobPriorityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .priority(JobPriority.unwrap(priority): Integer)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.UpdateJobPriorityRequest.ReadOnly =
    zio.aws.s3control.model.UpdateJobPriorityRequest.wrap(buildAwsValue())
}
object UpdateJobPriorityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.UpdateJobPriorityRequest =
      zio.aws.s3control.model
        .UpdateJobPriorityRequest(accountId, jobId, priority)
    def accountId: AccountId
    def jobId: JobId
    def priority: JobPriority
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getPriority: ZIO[Any, Nothing, JobPriority] = ZIO.succeed(priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest
  ) extends zio.aws.s3control.model.UpdateJobPriorityRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val jobId: JobId =
      zio.aws.s3control.model.primitives.JobId(impl.jobId())
    override val priority: JobPriority =
      zio.aws.s3control.model.primitives.JobPriority(impl.priority())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest
  ): zio.aws.s3control.model.UpdateJobPriorityRequest.ReadOnly = new Wrapper(
    impl
  )
}
