package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{
  JobStatusUpdateReason,
  JobId,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class UpdateJobStatusRequest(
    accountId: AccountId,
    jobId: JobId,
    requestedJobStatus: zio.aws.s3control.model.RequestedJobStatus,
    statusUpdateReason: Optional[JobStatusUpdateReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest = {
    import UpdateJobStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .requestedJobStatus(requestedJobStatus.unwrap)
      .optionallyWith(
        statusUpdateReason.map(value =>
          JobStatusUpdateReason.unwrap(value): java.lang.String
        )
      )(_.statusUpdateReason)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.UpdateJobStatusRequest.ReadOnly =
    zio.aws.s3control.model.UpdateJobStatusRequest.wrap(buildAwsValue())
}
object UpdateJobStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.UpdateJobStatusRequest =
      zio.aws.s3control.model.UpdateJobStatusRequest(
        accountId,
        jobId,
        requestedJobStatus,
        statusUpdateReason.map(value => value)
      )
    def accountId: AccountId
    def jobId: JobId
    def requestedJobStatus: zio.aws.s3control.model.RequestedJobStatus
    def statusUpdateReason: Optional[JobStatusUpdateReason]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getRequestedJobStatus
        : ZIO[Any, Nothing, zio.aws.s3control.model.RequestedJobStatus] =
      ZIO.succeed(requestedJobStatus)
    def getStatusUpdateReason: ZIO[Any, AwsError, JobStatusUpdateReason] =
      AwsError.unwrapOptionField("statusUpdateReason", statusUpdateReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest
  ) extends zio.aws.s3control.model.UpdateJobStatusRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val jobId: JobId =
      zio.aws.s3control.model.primitives.JobId(impl.jobId())
    override val requestedJobStatus
        : zio.aws.s3control.model.RequestedJobStatus =
      zio.aws.s3control.model.RequestedJobStatus.wrap(impl.requestedJobStatus())
    override val statusUpdateReason: Optional[JobStatusUpdateReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusUpdateReason())
        .map(value =>
          zio.aws.s3control.model.primitives.JobStatusUpdateReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest
  ): zio.aws.s3control.model.UpdateJobStatusRequest.ReadOnly = new Wrapper(impl)
}
