package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.VpcId
import scala.jdk.CollectionConverters.*
final case class VpcConfiguration(vpcId: VpcId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.VpcConfiguration = {
    import VpcConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.VpcConfiguration
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.VpcConfiguration.ReadOnly =
    zio.aws.s3control.model.VpcConfiguration.wrap(buildAwsValue())
}
object VpcConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.VpcConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.VpcConfiguration =
      zio.aws.s3control.model.VpcConfiguration(vpcId)
    def vpcId: VpcId
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.VpcConfiguration
  ) extends zio.aws.s3control.model.VpcConfiguration.ReadOnly {
    override val vpcId: VpcId =
      zio.aws.s3control.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.VpcConfiguration
  ): zio.aws.s3control.model.VpcConfiguration.ReadOnly = new Wrapper(impl)
}
