package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ActionStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ActionStatus
}
object ActionStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ActionStatus
  ): zio.aws.sagemaker.model.ActionStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ActionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ActionStatus.UNKNOWN =>
      val r = Unknown
      r
    case software.amazon.awssdk.services.sagemaker.model.ActionStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.ActionStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.ActionStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.ActionStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.ActionStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ActionStatus =
      software.amazon.awssdk.services.sagemaker.model.ActionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Unknown extends zio.aws.sagemaker.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ActionStatus =
      software.amazon.awssdk.services.sagemaker.model.ActionStatus.UNKNOWN
  }
  case object InProgress extends zio.aws.sagemaker.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ActionStatus =
      software.amazon.awssdk.services.sagemaker.model.ActionStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.sagemaker.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ActionStatus =
      software.amazon.awssdk.services.sagemaker.model.ActionStatus.COMPLETED
  }
  case object Failed extends zio.aws.sagemaker.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ActionStatus =
      software.amazon.awssdk.services.sagemaker.model.ActionStatus.FAILED
  }
  case object Stopping extends zio.aws.sagemaker.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ActionStatus =
      software.amazon.awssdk.services.sagemaker.model.ActionStatus.STOPPING
  }
  case object Stopped extends zio.aws.sagemaker.model.ActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ActionStatus =
      software.amazon.awssdk.services.sagemaker.model.ActionStatus.STOPPED
  }
}
