package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AppSecurityGroupManagement {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement
}
object AppSecurityGroupManagement {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement
  ): zio.aws.sagemaker.model.AppSecurityGroupManagement = value match {
    case software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement.SERVICE =>
      val r = Service
      r
    case software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement.CUSTOMER =>
      val r = Customer
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AppSecurityGroupManagement {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement =
      software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement.UNKNOWN_TO_SDK_VERSION
  }
  case object Service
      extends zio.aws.sagemaker.model.AppSecurityGroupManagement {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement =
      software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement.SERVICE
  }
  case object Customer
      extends zio.aws.sagemaker.model.AppSecurityGroupManagement {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement =
      software.amazon.awssdk.services.sagemaker.model.AppSecurityGroupManagement.CUSTOMER
  }
}
