package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AppStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AppStatus
}
object AppStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AppStatus
  ): zio.aws.sagemaker.model.AppStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.AppStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AppStatus.DELETED =>
      val r = Deleted
      r
    case software.amazon.awssdk.services.sagemaker.model.AppStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.AppStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.AppStatus.IN_SERVICE =>
      val r = InService
      r
    case software.amazon.awssdk.services.sagemaker.model.AppStatus.PENDING =>
      val r = Pending
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.AppStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppStatus =
      software.amazon.awssdk.services.sagemaker.model.AppStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Deleted extends zio.aws.sagemaker.model.AppStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppStatus =
      software.amazon.awssdk.services.sagemaker.model.AppStatus.DELETED
  }
  case object Deleting extends zio.aws.sagemaker.model.AppStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppStatus =
      software.amazon.awssdk.services.sagemaker.model.AppStatus.DELETING
  }
  case object Failed extends zio.aws.sagemaker.model.AppStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppStatus =
      software.amazon.awssdk.services.sagemaker.model.AppStatus.FAILED
  }
  case object InService extends zio.aws.sagemaker.model.AppStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppStatus =
      software.amazon.awssdk.services.sagemaker.model.AppStatus.IN_SERVICE
  }
  case object Pending extends zio.aws.sagemaker.model.AppStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AppStatus =
      software.amazon.awssdk.services.sagemaker.model.AppStatus.PENDING
  }
}
