package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ArtifactSourceIdType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType
}
object ArtifactSourceIdType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType
  ): zio.aws.sagemaker.model.ArtifactSourceIdType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType.MD5_HASH =>
      val r = MD5Hash
      r
    case software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType.S3_E_TAG =>
      val r = S3ETag
      r
    case software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType.S3_VERSION =>
      val r = S3Version
      r
    case software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType.CUSTOM =>
      val r = Custom
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ArtifactSourceIdType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType =
      software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType.UNKNOWN_TO_SDK_VERSION
  }
  case object MD5Hash extends zio.aws.sagemaker.model.ArtifactSourceIdType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType =
      software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType.MD5_HASH
  }
  case object S3ETag extends zio.aws.sagemaker.model.ArtifactSourceIdType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType =
      software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType.S3_E_TAG
  }
  case object S3Version extends zio.aws.sagemaker.model.ArtifactSourceIdType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType =
      software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType.S3_VERSION
  }
  case object Custom extends zio.aws.sagemaker.model.ArtifactSourceIdType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType =
      software.amazon.awssdk.services.sagemaker.model.ArtifactSourceIdType.CUSTOM
  }
}
