package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AssemblyType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AssemblyType
}
object AssemblyType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AssemblyType
  ): zio.aws.sagemaker.model.AssemblyType = value match {
    case software.amazon.awssdk.services.sagemaker.model.AssemblyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AssemblyType.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.sagemaker.model.AssemblyType.LINE =>
      val r = Line
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.AssemblyType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AssemblyType =
      software.amazon.awssdk.services.sagemaker.model.AssemblyType.UNKNOWN_TO_SDK_VERSION
  }
  case object None extends zio.aws.sagemaker.model.AssemblyType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AssemblyType =
      software.amazon.awssdk.services.sagemaker.model.AssemblyType.NONE
  }
  case object Line extends zio.aws.sagemaker.model.AssemblyType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AssemblyType =
      software.amazon.awssdk.services.sagemaker.model.AssemblyType.LINE
  }
}
