package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AutoMLDataSource(
    s3DataSource: zio.aws.sagemaker.model.AutoMLS3DataSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLDataSource = {
    import AutoMLDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLDataSource
      .builder()
      .s3DataSource(s3DataSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLDataSource.ReadOnly =
    zio.aws.sagemaker.model.AutoMLDataSource.wrap(buildAwsValue())
}
object AutoMLDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLDataSource =
      zio.aws.sagemaker.model.AutoMLDataSource(s3DataSource.asEditable)
    def s3DataSource: zio.aws.sagemaker.model.AutoMLS3DataSource.ReadOnly
    def getS3DataSource: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AutoMLS3DataSource.ReadOnly
    ] = ZIO.succeed(s3DataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLDataSource
  ) extends zio.aws.sagemaker.model.AutoMLDataSource.ReadOnly {
    override val s3DataSource
        : zio.aws.sagemaker.model.AutoMLS3DataSource.ReadOnly =
      zio.aws.sagemaker.model.AutoMLS3DataSource.wrap(impl.s3DataSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLDataSource
  ): zio.aws.sagemaker.model.AutoMLDataSource.ReadOnly = new Wrapper(impl)
}
