package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoRollbackConfig(
    alarms: Optional[Iterable[zio.aws.sagemaker.model.Alarm]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoRollbackConfig = {
    import AutoRollbackConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoRollbackConfig
      .builder()
      .optionallyWith(
        alarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alarms)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoRollbackConfig.ReadOnly =
    zio.aws.sagemaker.model.AutoRollbackConfig.wrap(buildAwsValue())
}
object AutoRollbackConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoRollbackConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoRollbackConfig =
      zio.aws.sagemaker.model.AutoRollbackConfig(
        alarms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def alarms: Optional[List[zio.aws.sagemaker.model.Alarm.ReadOnly]]
    def getAlarms
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Alarm.ReadOnly]] =
      AwsError.unwrapOptionField("alarms", alarms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoRollbackConfig
  ) extends zio.aws.sagemaker.model.AutoRollbackConfig.ReadOnly {
    override val alarms
        : Optional[List[zio.aws.sagemaker.model.Alarm.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Alarm.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoRollbackConfig
  ): zio.aws.sagemaker.model.AutoRollbackConfig.ReadOnly = new Wrapper(impl)
}
