package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AwsManagedHumanLoopRequestSource {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AwsManagedHumanLoopRequestSource
}
object AwsManagedHumanLoopRequestSource {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AwsManagedHumanLoopRequestSource
  ): zio.aws.sagemaker.model.AwsManagedHumanLoopRequestSource = value match {
    case software.amazon.awssdk.services.sagemaker.model.AwsManagedHumanLoopRequestSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AwsManagedHumanLoopRequestSource.AWS_REKOGNITION_DETECT_MODERATION_LABELS_IMAGE_V3 =>
      val r = `AWS/Rekognition/DetectModerationLabels/Image/V3`
      r
    case software.amazon.awssdk.services.sagemaker.model.AwsManagedHumanLoopRequestSource.AWS_TEXTRACT_ANALYZE_DOCUMENT_FORMS_V1 =>
      val r = `AWS/Textract/AnalyzeDocument/Forms/V1`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AwsManagedHumanLoopRequestSource {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AwsManagedHumanLoopRequestSource =
      software.amazon.awssdk.services.sagemaker.model.AwsManagedHumanLoopRequestSource.UNKNOWN_TO_SDK_VERSION
  }
  case object `AWS/Rekognition/DetectModerationLabels/Image/V3`
      extends zio.aws.sagemaker.model.AwsManagedHumanLoopRequestSource {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AwsManagedHumanLoopRequestSource =
      software.amazon.awssdk.services.sagemaker.model.AwsManagedHumanLoopRequestSource.AWS_REKOGNITION_DETECT_MODERATION_LABELS_IMAGE_V3
  }
  case object `AWS/Textract/AnalyzeDocument/Forms/V1`
      extends zio.aws.sagemaker.model.AwsManagedHumanLoopRequestSource {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AwsManagedHumanLoopRequestSource =
      software.amazon.awssdk.services.sagemaker.model.AwsManagedHumanLoopRequestSource.AWS_TEXTRACT_ANALYZE_DOCUMENT_FORMS_V1
  }
}
