package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDescribeModelPackageError(
    errorCode: String,
    errorResponse: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageError = {
    import BatchDescribeModelPackageError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageError
      .builder()
      .errorCode(errorCode: java.lang.String)
      .errorResponse(errorResponse: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.BatchDescribeModelPackageError.ReadOnly =
    zio.aws.sagemaker.model.BatchDescribeModelPackageError.wrap(buildAwsValue())
}
object BatchDescribeModelPackageError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.BatchDescribeModelPackageError =
      zio.aws.sagemaker.model
        .BatchDescribeModelPackageError(errorCode, errorResponse)
    def errorCode: String
    def errorResponse: String
    def getErrorCode: ZIO[Any, Nothing, String] = ZIO.succeed(errorCode)
    def getErrorResponse: ZIO[Any, Nothing, String] = ZIO.succeed(errorResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageError
  ) extends zio.aws.sagemaker.model.BatchDescribeModelPackageError.ReadOnly {
    override val errorCode: String = impl.errorCode(): String
    override val errorResponse: String = impl.errorResponse(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageError
  ): zio.aws.sagemaker.model.BatchDescribeModelPackageError.ReadOnly =
    new Wrapper(impl)
}
