package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ModelPackageArn
import scala.jdk.CollectionConverters._
final case class BatchDescribeModelPackageRequest(
    modelPackageArnList: Iterable[ModelPackageArn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest = {
    import BatchDescribeModelPackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest
      .builder()
      .modelPackageArnList(modelPackageArnList.map { item =>
        ModelPackageArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.BatchDescribeModelPackageRequest.ReadOnly =
    zio.aws.sagemaker.model.BatchDescribeModelPackageRequest
      .wrap(buildAwsValue())
}
object BatchDescribeModelPackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.BatchDescribeModelPackageRequest =
      zio.aws.sagemaker.model
        .BatchDescribeModelPackageRequest(modelPackageArnList)
    def modelPackageArnList: List[ModelPackageArn]
    def getModelPackageArnList: ZIO[Any, Nothing, List[ModelPackageArn]] =
      ZIO.succeed(modelPackageArnList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest
  ) extends zio.aws.sagemaker.model.BatchDescribeModelPackageRequest.ReadOnly {
    override val modelPackageArnList: List[ModelPackageArn] = impl
      .modelPackageArnList()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.ModelPackageArn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest
  ): zio.aws.sagemaker.model.BatchDescribeModelPackageRequest.ReadOnly =
    new Wrapper(impl)
}
