package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait BatchStrategy {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.BatchStrategy
}
object BatchStrategy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.BatchStrategy
  ): zio.aws.sagemaker.model.BatchStrategy = value match {
    case software.amazon.awssdk.services.sagemaker.model.BatchStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.BatchStrategy.MULTI_RECORD =>
      val r = MultiRecord
      r
    case software.amazon.awssdk.services.sagemaker.model.BatchStrategy.SINGLE_RECORD =>
      val r = SingleRecord
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.BatchStrategy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.BatchStrategy =
      software.amazon.awssdk.services.sagemaker.model.BatchStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object MultiRecord extends zio.aws.sagemaker.model.BatchStrategy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.BatchStrategy =
      software.amazon.awssdk.services.sagemaker.model.BatchStrategy.MULTI_RECORD
  }
  case object SingleRecord extends zio.aws.sagemaker.model.BatchStrategy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.BatchStrategy =
      software.amazon.awssdk.services.sagemaker.model.BatchStrategy.SINGLE_RECORD
  }
}
