package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.PipelineExecutionArn
import scala.jdk.CollectionConverters._
final case class CacheHitResult(
    sourcePipelineExecutionArn: Optional[PipelineExecutionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CacheHitResult = {
    import CacheHitResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CacheHitResult
      .builder()
      .optionallyWith(
        sourcePipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.sourcePipelineExecutionArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CacheHitResult.ReadOnly =
    zio.aws.sagemaker.model.CacheHitResult.wrap(buildAwsValue())
}
object CacheHitResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CacheHitResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CacheHitResult =
      zio.aws.sagemaker.model
        .CacheHitResult(sourcePipelineExecutionArn.map(value => value))
    def sourcePipelineExecutionArn: Optional[PipelineExecutionArn]
    def getSourcePipelineExecutionArn
        : ZIO[Any, AwsError, PipelineExecutionArn] = AwsError.unwrapOptionField(
      "sourcePipelineExecutionArn",
      sourcePipelineExecutionArn
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CacheHitResult
  ) extends zio.aws.sagemaker.model.CacheHitResult.ReadOnly {
    override val sourcePipelineExecutionArn: Optional[PipelineExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePipelineExecutionArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CacheHitResult
  ): zio.aws.sagemaker.model.CacheHitResult.ReadOnly = new Wrapper(impl)
}
