package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CandidateProperties(
    candidateArtifactLocations: Optional[
      zio.aws.sagemaker.model.CandidateArtifactLocations
    ] = Optional.Absent,
    candidateMetrics: Optional[Iterable[zio.aws.sagemaker.model.MetricDatum]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CandidateProperties = {
    import CandidateProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CandidateProperties
      .builder()
      .optionallyWith(
        candidateArtifactLocations.map(value => value.buildAwsValue())
      )(_.candidateArtifactLocations)
      .optionallyWith(
        candidateMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.candidateMetrics)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CandidateProperties.ReadOnly =
    zio.aws.sagemaker.model.CandidateProperties.wrap(buildAwsValue())
}
object CandidateProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CandidateProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CandidateProperties =
      zio.aws.sagemaker.model.CandidateProperties(
        candidateArtifactLocations.map(value => value.asEditable),
        candidateMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def candidateArtifactLocations
        : Optional[zio.aws.sagemaker.model.CandidateArtifactLocations.ReadOnly]
    def candidateMetrics
        : Optional[List[zio.aws.sagemaker.model.MetricDatum.ReadOnly]]
    def getCandidateArtifactLocations: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CandidateArtifactLocations.ReadOnly
    ] = AwsError.unwrapOptionField(
      "candidateArtifactLocations",
      candidateArtifactLocations
    )
    def getCandidateMetrics: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.MetricDatum.ReadOnly
    ]] = AwsError.unwrapOptionField("candidateMetrics", candidateMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CandidateProperties
  ) extends zio.aws.sagemaker.model.CandidateProperties.ReadOnly {
    override val candidateArtifactLocations: Optional[
      zio.aws.sagemaker.model.CandidateArtifactLocations.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.candidateArtifactLocations())
      .map(value =>
        zio.aws.sagemaker.model.CandidateArtifactLocations.wrap(value)
      )
    override val candidateMetrics
        : Optional[List[zio.aws.sagemaker.model.MetricDatum.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.candidateMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.MetricDatum.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CandidateProperties
  ): zio.aws.sagemaker.model.CandidateProperties.ReadOnly = new Wrapper(impl)
}
