package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait CompressionType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.CompressionType
}
object CompressionType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.CompressionType
  ): zio.aws.sagemaker.model.CompressionType = value match {
    case software.amazon.awssdk.services.sagemaker.model.CompressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.CompressionType.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.sagemaker.model.CompressionType.GZIP =>
      val r = Gzip
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompressionType =
      software.amazon.awssdk.services.sagemaker.model.CompressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object None extends zio.aws.sagemaker.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompressionType =
      software.amazon.awssdk.services.sagemaker.model.CompressionType.NONE
  }
  case object Gzip extends zio.aws.sagemaker.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompressionType =
      software.amazon.awssdk.services.sagemaker.model.CompressionType.GZIP
  }
}
