package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ContainerMode {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ContainerMode
}
object ContainerMode {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ContainerMode
  ): zio.aws.sagemaker.model.ContainerMode = value match {
    case software.amazon.awssdk.services.sagemaker.model.ContainerMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ContainerMode.SINGLE_MODEL =>
      val r = SingleModel
      r
    case software.amazon.awssdk.services.sagemaker.model.ContainerMode.MULTI_MODEL =>
      val r = MultiModel
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ContainerMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ContainerMode =
      software.amazon.awssdk.services.sagemaker.model.ContainerMode.UNKNOWN_TO_SDK_VERSION
  }
  case object SingleModel extends zio.aws.sagemaker.model.ContainerMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ContainerMode =
      software.amazon.awssdk.services.sagemaker.model.ContainerMode.SINGLE_MODEL
  }
  case object MultiModel extends zio.aws.sagemaker.model.ContainerMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ContainerMode =
      software.amazon.awssdk.services.sagemaker.model.ContainerMode.MULTI_MODEL
  }
}
