package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  StringParameterValue,
  String256,
  ExperimentEntityName
}
import scala.jdk.CollectionConverters._
final case class CreateArtifactRequest(
    artifactName: Optional[ExperimentEntityName] = Optional.Absent,
    source: zio.aws.sagemaker.model.ArtifactSource,
    artifactType: String256,
    properties: Optional[Map[StringParameterValue, StringParameterValue]] =
      Optional.Absent,
    metadataProperties: Optional[zio.aws.sagemaker.model.MetadataProperties] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest = {
    import CreateArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest
      .builder()
      .optionallyWith(
        artifactName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.artifactName)
      .source(source.buildAwsValue())
      .artifactType(String256.unwrap(artifactType): java.lang.String)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (StringParameterValue.unwrap(
                key
              ): java.lang.String) -> (StringParameterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateArtifactRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateArtifactRequest.wrap(buildAwsValue())
}
object CreateArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateArtifactRequest =
      zio.aws.sagemaker.model.CreateArtifactRequest(
        artifactName.map(value => value),
        source.asEditable,
        artifactType,
        properties.map(value => value),
        metadataProperties.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def artifactName: Optional[ExperimentEntityName]
    def source: zio.aws.sagemaker.model.ArtifactSource.ReadOnly
    def artifactType: String256
    def properties: Optional[Map[StringParameterValue, StringParameterValue]]
    def metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getArtifactName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("artifactName", artifactName)
    def getSource
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ArtifactSource.ReadOnly] =
      ZIO.succeed(source)
    def getArtifactType: ZIO[Any, Nothing, String256] =
      ZIO.succeed(artifactType)
    def getProperties
        : ZIO[Any, AwsError, Map[StringParameterValue, StringParameterValue]] =
      AwsError.unwrapOptionField("properties", properties)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest
  ) extends zio.aws.sagemaker.model.CreateArtifactRequest.ReadOnly {
    override val artifactName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val source: zio.aws.sagemaker.model.ArtifactSource.ReadOnly =
      zio.aws.sagemaker.model.ArtifactSource.wrap(impl.source())
    override val artifactType: String256 =
      zio.aws.sagemaker.model.primitives.String256(impl.artifactType())
    override val properties
        : Optional[Map[StringParameterValue, StringParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives
                .StringParameterValue(key) -> zio.aws.sagemaker.model.primitives
                .StringParameterValue(value)
            })
            .toMap
        )
    override val metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataProperties())
        .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest
  ): zio.aws.sagemaker.model.CreateArtifactRequest.ReadOnly = new Wrapper(impl)
}
