package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  EnableIotRoleAlias,
  DeviceFleetDescription,
  RoleArn,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class CreateDeviceFleetRequest(
    deviceFleetName: EntityName,
    roleArn: Optional[RoleArn] = Optional.Absent,
    description: Optional[DeviceFleetDescription] = Optional.Absent,
    outputConfig: zio.aws.sagemaker.model.EdgeOutputConfig,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    enableIotRoleAlias: Optional[EnableIotRoleAlias] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest = {
    import CreateDeviceFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest
      .builder()
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        description.map(value =>
          DeviceFleetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .outputConfig(outputConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        enableIotRoleAlias.map(value =>
          EnableIotRoleAlias.unwrap(value): java.lang.Boolean
        )
      )(_.enableIotRoleAlias)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateDeviceFleetRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateDeviceFleetRequest.wrap(buildAwsValue())
}
object CreateDeviceFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateDeviceFleetRequest =
      zio.aws.sagemaker.model.CreateDeviceFleetRequest(
        deviceFleetName,
        roleArn.map(value => value),
        description.map(value => value),
        outputConfig.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableIotRoleAlias.map(value => value)
      )
    def deviceFleetName: EntityName
    def roleArn: Optional[RoleArn]
    def description: Optional[DeviceFleetDescription]
    def outputConfig: zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def enableIotRoleAlias: Optional[EnableIotRoleAlias]
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDescription: ZIO[Any, AwsError, DeviceFleetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getOutputConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly] =
      ZIO.succeed(outputConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnableIotRoleAlias: ZIO[Any, AwsError, EnableIotRoleAlias] =
      AwsError.unwrapOptionField("enableIotRoleAlias", enableIotRoleAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest
  ) extends zio.aws.sagemaker.model.CreateDeviceFleetRequest.ReadOnly {
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val description: Optional[DeviceFleetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.DeviceFleetDescription(value)
        )
    override val outputConfig
        : zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.EdgeOutputConfig.wrap(impl.outputConfig())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val enableIotRoleAlias: Optional[EnableIotRoleAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableIotRoleAlias())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EnableIotRoleAlias(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest
  ): zio.aws.sagemaker.model.CreateDeviceFleetRequest.ReadOnly = new Wrapper(
    impl
  )
}
