package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{
  ImageName,
  ClientToken,
  ImageBaseImage
}
import scala.jdk.CollectionConverters._
final case class CreateImageVersionRequest(
    baseImage: ImageBaseImage,
    clientToken: ClientToken,
    imageName: ImageName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest = {
    import CreateImageVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest
      .builder()
      .baseImage(ImageBaseImage.unwrap(baseImage): java.lang.String)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateImageVersionRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateImageVersionRequest.wrap(buildAwsValue())
}
object CreateImageVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateImageVersionRequest =
      zio.aws.sagemaker.model
        .CreateImageVersionRequest(baseImage, clientToken, imageName)
    def baseImage: ImageBaseImage
    def clientToken: ClientToken
    def imageName: ImageName
    def getBaseImage: ZIO[Any, Nothing, ImageBaseImage] = ZIO.succeed(baseImage)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest
  ) extends zio.aws.sagemaker.model.CreateImageVersionRequest.ReadOnly {
    override val baseImage: ImageBaseImage =
      zio.aws.sagemaker.model.primitives.ImageBaseImage(impl.baseImage())
    override val clientToken: ClientToken =
      zio.aws.sagemaker.model.primitives.ClientToken(impl.clientToken())
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest
  ): zio.aws.sagemaker.model.CreateImageVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
