package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{EntityDescription, EntityName}
import scala.jdk.CollectionConverters._
final case class CreateModelPackageGroupRequest(
    modelPackageGroupName: EntityName,
    modelPackageGroupDescription: Optional[EntityDescription] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest = {
    import CreateModelPackageGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest
      .builder()
      .modelPackageGroupName(
        EntityName.unwrap(modelPackageGroupName): java.lang.String
      )
      .optionallyWith(
        modelPackageGroupDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupDescription)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateModelPackageGroupRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateModelPackageGroupRequest.wrap(buildAwsValue())
}
object CreateModelPackageGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelPackageGroupRequest =
      zio.aws.sagemaker.model.CreateModelPackageGroupRequest(
        modelPackageGroupName,
        modelPackageGroupDescription.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def modelPackageGroupName: EntityName
    def modelPackageGroupDescription: Optional[EntityDescription]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getModelPackageGroupName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelPackageGroupName)
    def getModelPackageGroupDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField(
        "modelPackageGroupDescription",
        modelPackageGroupDescription
      )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest
  ) extends zio.aws.sagemaker.model.CreateModelPackageGroupRequest.ReadOnly {
    override val modelPackageGroupName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.modelPackageGroupName())
    override val modelPackageGroupDescription: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageGroupDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest
  ): zio.aws.sagemaker.model.CreateModelPackageGroupRequest.ReadOnly =
    new Wrapper(impl)
}
