package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  KmsKeyId,
  DestinationS3Uri,
  SamplingPercentage,
  EnableCapture
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DataCaptureConfig(
    enableCapture: Optional[EnableCapture] = Optional.Absent,
    initialSamplingPercentage: SamplingPercentage,
    destinationS3Uri: DestinationS3Uri,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    captureOptions: Iterable[zio.aws.sagemaker.model.CaptureOption],
    captureContentTypeHeader: Optional[
      zio.aws.sagemaker.model.CaptureContentTypeHeader
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig = {
    import DataCaptureConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig
      .builder()
      .optionallyWith(
        enableCapture.map(value =>
          EnableCapture.unwrap(value): java.lang.Boolean
        )
      )(_.enableCapture)
      .initialSamplingPercentage(
        SamplingPercentage.unwrap(initialSamplingPercentage): Integer
      )
      .destinationS3Uri(
        DestinationS3Uri.unwrap(destinationS3Uri): java.lang.String
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .captureOptions(captureOptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        captureContentTypeHeader.map(value => value.buildAwsValue())
      )(_.captureContentTypeHeader)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly =
    zio.aws.sagemaker.model.DataCaptureConfig.wrap(buildAwsValue())
}
object DataCaptureConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DataCaptureConfig =
      zio.aws.sagemaker.model.DataCaptureConfig(
        enableCapture.map(value => value),
        initialSamplingPercentage,
        destinationS3Uri,
        kmsKeyId.map(value => value),
        captureOptions.map { item =>
          item.asEditable
        },
        captureContentTypeHeader.map(value => value.asEditable)
      )
    def enableCapture: Optional[EnableCapture]
    def initialSamplingPercentage: SamplingPercentage
    def destinationS3Uri: DestinationS3Uri
    def kmsKeyId: Optional[KmsKeyId]
    def captureOptions: List[zio.aws.sagemaker.model.CaptureOption.ReadOnly]
    def captureContentTypeHeader
        : Optional[zio.aws.sagemaker.model.CaptureContentTypeHeader.ReadOnly]
    def getEnableCapture: ZIO[Any, AwsError, EnableCapture] =
      AwsError.unwrapOptionField("enableCapture", enableCapture)
    def getInitialSamplingPercentage: ZIO[Any, Nothing, SamplingPercentage] =
      ZIO.succeed(initialSamplingPercentage)
    def getDestinationS3Uri: ZIO[Any, Nothing, DestinationS3Uri] =
      ZIO.succeed(destinationS3Uri)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getCaptureOptions: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.CaptureOption.ReadOnly
    ]] = ZIO.succeed(captureOptions)
    def getCaptureContentTypeHeader: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CaptureContentTypeHeader.ReadOnly
    ] = AwsError.unwrapOptionField(
      "captureContentTypeHeader",
      captureContentTypeHeader
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig
  ) extends zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly {
    override val enableCapture: Optional[EnableCapture] = zio.aws.core.internal
      .optionalFromNullable(impl.enableCapture())
      .map(value => zio.aws.sagemaker.model.primitives.EnableCapture(value))
    override val initialSamplingPercentage: SamplingPercentage =
      zio.aws.sagemaker.model.primitives
        .SamplingPercentage(impl.initialSamplingPercentage())
    override val destinationS3Uri: DestinationS3Uri =
      zio.aws.sagemaker.model.primitives
        .DestinationS3Uri(impl.destinationS3Uri())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val captureOptions
        : List[zio.aws.sagemaker.model.CaptureOption.ReadOnly] = impl
      .captureOptions()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.CaptureOption.wrap(item)
      }
      .toList
    override val captureContentTypeHeader
        : Optional[zio.aws.sagemaker.model.CaptureContentTypeHeader.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.captureContentTypeHeader())
        .map(value =>
          zio.aws.sagemaker.model.CaptureContentTypeHeader.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig
  ): zio.aws.sagemaker.model.DataCaptureConfig.ReadOnly = new Wrapper(impl)
}
