package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{
  KmsKeyId,
  DestinationS3Uri,
  SamplingPercentage,
  EnableCapture
}
import scala.jdk.CollectionConverters._
final case class DataCaptureConfigSummary(
    enableCapture: EnableCapture,
    captureStatus: zio.aws.sagemaker.model.CaptureStatus,
    currentSamplingPercentage: SamplingPercentage,
    destinationS3Uri: DestinationS3Uri,
    kmsKeyId: KmsKeyId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DataCaptureConfigSummary = {
    import DataCaptureConfigSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DataCaptureConfigSummary
      .builder()
      .enableCapture(EnableCapture.unwrap(enableCapture): java.lang.Boolean)
      .captureStatus(captureStatus.unwrap)
      .currentSamplingPercentage(
        SamplingPercentage.unwrap(currentSamplingPercentage): Integer
      )
      .destinationS3Uri(
        DestinationS3Uri.unwrap(destinationS3Uri): java.lang.String
      )
      .kmsKeyId(KmsKeyId.unwrap(kmsKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DataCaptureConfigSummary.ReadOnly =
    zio.aws.sagemaker.model.DataCaptureConfigSummary.wrap(buildAwsValue())
}
object DataCaptureConfigSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DataCaptureConfigSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DataCaptureConfigSummary =
      zio.aws.sagemaker.model.DataCaptureConfigSummary(
        enableCapture,
        captureStatus,
        currentSamplingPercentage,
        destinationS3Uri,
        kmsKeyId
      )
    def enableCapture: EnableCapture
    def captureStatus: zio.aws.sagemaker.model.CaptureStatus
    def currentSamplingPercentage: SamplingPercentage
    def destinationS3Uri: DestinationS3Uri
    def kmsKeyId: KmsKeyId
    def getEnableCapture: ZIO[Any, Nothing, EnableCapture] =
      ZIO.succeed(enableCapture)
    def getCaptureStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.CaptureStatus] =
      ZIO.succeed(captureStatus)
    def getCurrentSamplingPercentage: ZIO[Any, Nothing, SamplingPercentage] =
      ZIO.succeed(currentSamplingPercentage)
    def getDestinationS3Uri: ZIO[Any, Nothing, DestinationS3Uri] =
      ZIO.succeed(destinationS3Uri)
    def getKmsKeyId: ZIO[Any, Nothing, KmsKeyId] = ZIO.succeed(kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DataCaptureConfigSummary
  ) extends zio.aws.sagemaker.model.DataCaptureConfigSummary.ReadOnly {
    override val enableCapture: EnableCapture =
      zio.aws.sagemaker.model.primitives.EnableCapture(impl.enableCapture())
    override val captureStatus: zio.aws.sagemaker.model.CaptureStatus =
      zio.aws.sagemaker.model.CaptureStatus.wrap(impl.captureStatus())
    override val currentSamplingPercentage: SamplingPercentage =
      zio.aws.sagemaker.model.primitives
        .SamplingPercentage(impl.currentSamplingPercentage())
    override val destinationS3Uri: DestinationS3Uri =
      zio.aws.sagemaker.model.primitives
        .DestinationS3Uri(impl.destinationS3Uri())
    override val kmsKeyId: KmsKeyId =
      zio.aws.sagemaker.model.primitives.KmsKeyId(impl.kmsKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DataCaptureConfigSummary
  ): zio.aws.sagemaker.model.DataCaptureConfigSummary.ReadOnly = new Wrapper(
    impl
  )
}
