package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class DeleteDeviceFleetRequest(deviceFleetName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest = {
    import DeleteDeviceFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest
      .builder()
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteDeviceFleetRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteDeviceFleetRequest.wrap(buildAwsValue())
}
object DeleteDeviceFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteDeviceFleetRequest =
      zio.aws.sagemaker.model.DeleteDeviceFleetRequest(deviceFleetName)
    def deviceFleetName: EntityName
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest
  ) extends zio.aws.sagemaker.model.DeleteDeviceFleetRequest.ReadOnly {
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest
  ): zio.aws.sagemaker.model.DeleteDeviceFleetRequest.ReadOnly = new Wrapper(
    impl
  )
}
