package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters._
final case class DeleteExperimentRequest(experimentName: ExperimentEntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest = {
    import DeleteExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest
      .builder()
      .experimentName(
        ExperimentEntityName.unwrap(experimentName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteExperimentRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteExperimentRequest.wrap(buildAwsValue())
}
object DeleteExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteExperimentRequest =
      zio.aws.sagemaker.model.DeleteExperimentRequest(experimentName)
    def experimentName: ExperimentEntityName
    def getExperimentName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(experimentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest
  ) extends zio.aws.sagemaker.model.DeleteExperimentRequest.ReadOnly {
    override val experimentName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.experimentName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest
  ): zio.aws.sagemaker.model.DeleteExperimentRequest.ReadOnly = new Wrapper(
    impl
  )
}
